﻿/*		VERSION: 	1.2
1.2			clone_textField() now copies the "embedFonts" setting
1.1			Added  txt.scrollDown()  txt.scrollUp()  so that external code can tell the scroll box to animate in a specific direction.

USAGE: 
	var updateOnce;		// Including updateOnce is optional,  theoretically helps performance,  and the top-text-line mask won't work right without it.  This is barely noiceable.
	#include "functions/updateOnce.as"
	#include "functions/smoothScroll.as"
	
	// create
	my_txt = smoothScroll( my_txt );
	
	// remove
	if( my_txt.onUnload )		my_txt = my_txt.onUnload();
	
	
	
	#include "functions/smoothScroll.as"
	// create
	new_txt = smoothScroll( old_txt, 0.5 );
	// remove
	old_txt = new_txt.onUnload();
	
	
NOTE: 
	UIScrollBar components will need to be manually assigned to the new textField after smoothScroll clones it.
	scroll_mc.setScrollTarget( new_txt );
	
	
WHAT THIS DOES: 
	This makes a smoothly-scrolling textField from an existing one.
	The original textField is hidden until the new one is removed by new_txt.onUnload();
	
	
HOW THIS WORKS: 
	This creates a movieClip, 
	clones the specified textField into it, 
	masks the movieClip, 
	hides the original textField.
	
	The smooth scrolling is accomplished by moving the pixel position of the cloned textField and moving a bitmap snapshot of its current top line of text.
	The entire system has a mask applied to it.  Everything needs to be wrapped inside of a movieClip because masks cannot directly affect textFields.
	

DEPENDENCIES: 
	#include "functions/runFunc.as"
	#include "functions/quikTween2.as"
	#include "functions/nextDepth.as"
	#include "functions/eventSystem3.as"
	
OPTIONAL DEPENDENCIES: 
	#include "functions/updateOnce.as"									Including updateOnce is optional, but may theoretically improve performance.  smoothScroll will use it if it's present.
*/



function smoothScroll( new_old_txt, animSeconds ){
	// how fast is the scroll animation
	var animSeconds = animSeconds || 0.2;
	
	
	// if input is from another smooth-scroll system,  instantly replace that system with this one
	if( new_old_txt.old_txt ){
		// prepare to remove the previously existing smooth-scroll system
		var removeThis = new_old_txt.onUnload;
		// redirect to original textfield
		new_old_txt = new_old_txt.old_txt;
		// remove old smoothScroll instance, so that it can be instantly replaced by this new one
		removeThis();
	}// if;   input is from another smooth-scroll system
	
	// reject invaid input
	if(new_old_txt instanceof TextField === false)		return;
	
	
	var _this = this;
	var text_mc;
	var old_txt = new_old_txt;
	var new_txt;
	var topSnap_mc;
	var textMargin = 2;		// textfields always have a margin of 2 pixels on all sides
	
	#include "functions/runFunc.as"
	#include "functions/quikTween2.as"
	#include "functions/nextDepth.as"
	#include "functions/eventSystem3.as"
	var react;
	
	
	// Create a movieClip at the location of the old textfield.
	var newDepth = nextDepth( _this );
	var newName = "scrollTextField" + newDepth + "_mc";
	text_mc = _this.createEmptyMovieClip( newName, newDepth );
	text_mc._x = old_txt._x;
	text_mc._y = old_txt._y;
	AsBroadcaster.initialize( text_mc );
	react = make_react( text_mc );		// param is optional
	
	// Create a new textfield within the new movieClip that uses the same formatting as the old one.
	new_txt = clone_textField( text_mc, old_txt );
	// Create a mask and apply it to this movieClip.
	setup_mask( text_mc, new_txt, textMargin );
	// Create a snapshot movieClip and bitmap image  +  Set up scrolling behavior
	setup_scrolling( text_mc, new_txt, textMargin );
	
	// Hide the old textfield.
	old_txt._visible = false;
	
	// allow additional instances to chain together
	new_txt.old_txt = old_txt;
	
	// add unload() function
	new_txt.onUnload = text_mc.onUnload = function(){
		sendEvent( "unload", null, text_mc );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
		// Return the old textfield.
		return old_txt;
	}// onUnload()
	
	react.to("unload").then = function(){
		// Reveal the old textfield.
		old_txt._visible = true;
		// Remove the movieClip.
		text_mc._name = null;		// required to allow instant replacement
		text_mc.removeMovieClip();
	}// unload()
	
	// Return the new textfield.
	return new_txt;
	
	
	
	
	
	
	
			
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	
	
	function clone_textField( text_mc, old_txt ){
		var w = old_txt._width;
		var h = old_txt._height;
		var self = text_mc.createTextField( "new_txt", nextDepth(text_mc), 0, 0, w, h );
		// properties
		self.type = old_txt.type;
		self.html = old_txt.html;
		self.maxChars = old_txt.maxChars;
		self.selectable = old_txt.selectable;
		self.wordWrap = old_txt.wordWrap;
		self.multiline = old_txt.multiline;
		self.restrict = old_txt.restrict;
		self.variable = old_txt.variable;
		self.scroll = old_txt.scroll;
		self.embedFonts = old_txt.embedFonts;
		// copy text formatting
		var fmt = old_txt.getTextFormat();
		self.setNewTextFormat( fmt );
		// copy existing text
		self.htmlText = old_txt.htmlText;
		// self.setTextFormat( fmt );
		// 
		return self;
	}// clone_textField()
	
	
	
	function setup_mask( text_mc, textField, textMargin ){
		var self = text_mc.createEmptyMovieClip("maskArea", nextDepth( text_mc )  );
		//  draw a box
		self.beginFill( 0, 100 );		// solid black
		self.moveTo( 0, 0 );
		self.lineTo( 10, 0 );		// right
		self.lineTo( 10, 10 );		// down
		self.lineTo( 0, 10 );		// left
		self.lineTo( 0, 0 );			// up
		self.endFill();
		// get textfield size + totalLines
		var fmt = textField.getTextFormat();
		var meas = fmt.getTextExtent( " " );
		var lineHeight = meas.height;
		var allMargins = textMargin*2;
		
		var totalLines = Math.ceil( (textField._height -allMargins) / lineHeight ) -1;		// ceil so that it always removes the last line, even when it's exactly the right size for all its lines
		// resize
		self._width = textField._width;
		self._height = textMargin + (lineHeight * totalLines);
		
		// apply mask to this movieClip
		text_mc.setMask( self );
		
		return self;
	}// setup_mask()
	
	
	
	function setup_scrolling( text_mc, new_txt, margin ){
		var self = new_txt;
		var lastPos = self.scroll;
		var fmt = self.getTextFormat();
		var lineHeight = fmt.getTextExtent( " " ).height;
		var ignoreScrollEvent = false;
		var anim;
		var animSnap;
		
		// make topSnap_mc  (requires updateOnce.as to work right,  but it's barely noticeable when it's missing)
		var topSnap_mc = text_mc.createEmptyMovieClip("topSnap_mc", nextDepth( text_mc )  );
		// topSnap_mc._x = topSnap_mc._y = margin;		// textField margins are always 2
		topSnap_mc._y = margin;		// textField margins are always 2
		// make topSnap_pic + topSnap_rect
		var topSnap_rect = new flash.geom.Rectangle( 0, 0, self._width, lineHeight );
		var topSnap_pic = new flash.display.BitmapData( self._width, lineHeight -margin, true, 0 );
		// var topSnap_pic = new flash.display.BitmapData( self._width, lineHeight -margin, false, 0 );
		topSnap_mc.attachBitmap( topSnap_pic, 0 );
		
		// clean-up later
		react.to("unload").then = function(){
			topSnap_pic.dispose();
		}// unload()
		
		
		var onScroller = function( txt ){
			if( ignoreScrollEvent )		return;
			var newPos = self.scroll;
			var scrollDir = Math.abs( lastPos - newPos ) / (lastPos - newPos);		// -1 is down (text moved up),   +1 is up (text moved down)
			if( scrollDir === 0 )		return;		// no change  =>  do nothing
			
			var goingToLastLine = (newPos === self.maxscroll);
			//goingToLastLine = true;
			
			
			if( scrollDir === -1  &&  goingToLastLine ){
				// take a snapshot of the top line and "scroll" the image up
				ignoreScrollEvent = true;
				// scroll the text down temporarily so that the previous line is visible
				self.scroll = newPos-1;
				// take a picture of the previous line of text
				topSnap_pic.fillRect( topSnap_rect, 0 );
				topSnap_pic.draw( self );
				// scroll the text back up
				self.scroll = newPos;
				ignoreScrollEvent = false;
				
				// animate the snapshot "scrolling" up
				var startAt = margin;
				var endAt = -lineHeight;
				animSnap.abort();		animSnap.then = null;
				// shift the text higher by 1 line, temporarily
				animSnap = quikTween2( startAt, endAt, animSeconds, easeLinear );
				animSnap.onProgress = function( value ){
					topSnap_mc._y = value;
				}
				// done animating
				animSnap.then = function(){
					animSnap.then = null;
					animSnap = null;
				}// done()
				// animSnap.advanceFrame();
				animSnap.onProgress( startAt );
				topSnap_mc._visible = true;
			}// if: goingToLastLine
			else{
				topSnap_mc._visible = false;
			}
			
			
			if( scrollDir === -1 || goingToLastLine ){
				// text moving up
				scrollDown();
			}// if:  moving up
			else if( scrollDir === 1 ){
				// text moving down
				scrollUp();
			}// if:  moving down
			
			// 
			lastPos = newPos;
			//ignoreScrollEvent = false;
			
			
			function scrollDown(){
				// text moving up
				ignoreScrollEvent = true;
				var startAt = lineHeight;
				var endAt = 0;
				anim.abort();		anim.then = null;
				// shift the text higher by 1 line, temporarily
				anim = quikTween2( startAt, endAt, animSeconds, easeLinear );
				anim.onProgress = function( value ){
					self._y = value;
				}
				// done animating
				anim.then = function(){
					anim.then = null;
					// shift the text back down by 1 line to original scroll-position
					self._y = 0;
				}// done()
				// anim.advanceFrame();
				anim.onProgress( startAt );
				ignoreScrollEvent = false;
			}// scrollDown()
			
			
			function scrollUp(){
				// text moving down
				ignoreScrollEvent = true;
				var startAt = -lineHeight;
				var endAt = 0;
				anim.abort();		anim.then = null;
				anim = quikTween2( startAt, endAt, animSeconds, easeLinear );
				anim.onProgress = function( value ){
					self._y = value;
				}
				// anim.advanceFrame();
				anim.onProgress( startAt );
				ignoreScrollEvent = false;
			}// scrollUp()
			
			
			self.scrollDown = scrollDown;
			self.scrollUp = scrollUp;
		}// onScroller()
		
		
		if(updateOnce)		onScroller = updateOnce( onScroller );
		react.to("onScroller").from( self ).then = onScroller;
		
	}// setup_scrolling()

	
}// smoothScroll()